/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.zend.debugger.handlers;

import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org2.eclipse.php.debug.core.debugger.IDebugHandler;
import org2.eclipse.php.debug.core.debugger.handlers.IDebugMessageHandler;
import org2.eclipse.php.debug.core.debugger.messages.IDebugMessage;
import org2.eclipse.php.internal.core.util.FileUtils;
import org2.eclipse.php.internal.debug.core.model.PHPConditionalBreakpoint;
import org2.eclipse.php.internal.debug.core.preferences.stepFilters.DebugStepFilterController;
import org2.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org2.eclipse.php.internal.debug.core.zend.debugger.messages.ReadyNotification;
import org2.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;

public class ReadyNotificationHandler
implements IDebugMessageHandler {
    @Override
    public void handle(IDebugMessage message, PHPDebugTarget debugTarget) {
        block7: {
            ReadyNotification readyNotification = (ReadyNotification)message;
            String currentFile = readyNotification.getFileName();
            try {
                if (!debugTarget.isStepFiltersEnabled()) break block7;
                String localPath = ((RemoteDebugger)debugTarget.getRemoteDebugger()).convertToLocalFilename(currentFile);
                if (!DebugStepFilterController.getInstance().isFiltered(localPath)) break block7;
                try {
                    if (!this.isBreakPointExistInFile(debugTarget, currentFile)) {
                        debugTarget.getRemoteDebugger().stepInto();
                        return;
                    }
                }
                catch (CoreException ce) {
                    PHPDebugEPLPlugin.logError(ce);
                }
            }
            finally {
                int currentLine = readyNotification.getLineNumber();
                IDebugHandler debugHandler = debugTarget.getRemoteDebugger().getDebugHandler();
                debugHandler.ready(currentFile, currentLine);
            }
        }
    }

    private boolean isBreakPointExistInFile(PHPDebugTarget debugTarget, String currentFile) throws CoreException {
        IBreakpoint[] bPoints;
        IBreakpoint[] iBreakpointArray = bPoints = debugTarget.getBreakpointManager().getBreakpoints("org2.eclipse.php.debug.core");
        int n = bPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint bp = iBreakpointArray[n2];
            if (bp.isEnabled() && FileUtils.checkIfEqualFilePaths(((PHPConditionalBreakpoint)bp).getRuntimeBreakpoint().getFileName(), currentFile)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

